clear

log using table8_2.smcl, replace
run CostOfSystemCompliance.do


/// Table 8.2
logit feecomply lnfeeexpord atty, cluster(companyname)
outreg2 using "Table8_2.rtf", replace  ///
	label ctitle(FeeCompliance) alpha(0.01, 0.05, 0.10) symbol(**, *, +) /// 
	title("Table 8.2","Predictors of Fee Application Guidelines Compliance") ///
	addstat(Pseudo R-squared, `e(r2_p)') adec(2) bdec(3) rdec(2) addnote("Logit regression coefficients, clustered by debtor")
logit feecomply lnfeeexpord atty fa cc , cluster(companyname)
outreg2 using "Table8_2.rtf", append ///
	label ctitle(FeeCompliance) alpha(0.01, 0.05, 0.10) symbol(**, *, +) /// 
	addstat(Pseudo R-squared, `e(r2_p)') adec(2) bdec(3) rdec(2)
logit feecomply lnfeeexpord atty fa cc nonrandom, cluster(companyname)
outreg2 using "Table8_2.rtf", append ///
	label ctitle(FeeCompliance) alpha(0.01, 0.05, 0.10) symbol(**, *, +) /// 
	addstat(Pseudo R-squared, `e(r2_p)') adec(2) bdec(3) rdec(2)

logit feecomply c.lnfeeexpord##i.atty, cluster(companyname) 
tab lnfeeexpord if e(sample)==1
/// This is the probability of compliance at the 1st thru 9th deciles of application amount
margins, at(lnfeeexpord=(11.1 12.3 12.7 13.1 13.6 13.9 14.5 15.1 15.8))
/// This is the probability of compliance for non-atty and atty
margins i.atty
margins i.atty, at(lnfeeexpord=(11.1 12.3 12.7 13.1 13.6 13.9 14.5 15.1 15.8))

log close

clear	

log using table8_4.smcl, replace
run CostOfSystemCost.do

/// Table 8.4 
reg lnfeefeetotal lnfeexpapp, cluster(companyname)
outreg2 using Table8_4.rtf, replace /// 
	ctitle("FeeFeeTotal","(log)") label alpha(0.001, 0.01, 0.05) symbol(***, **, *) adjr2 bdec(3) rdec(2) ///
	title("Table 8.4","Determinants of Fee-Control Costs")
reg lnfeefeetotal lnfeexpapp yearconfirmed, cluster(companyname)
outreg2 using Table8_4.rtf, append /// 
	ctitle("FeeFeeTotal","(log)") label alpha(0.001, 0.01, 0.05) symbol(***, **, *) adjr2 bdec(3) rdec(2) 
reg lnfeefeetotal lnfeexpapp yearconfirmed leadccatty fa specatty, cluster(companyname)
outreg2 using Table8_4.rtf, append /// 
	ctitle("FeeFeeTotal","(log)") label alpha(0.001, 0.01, 0.05) symbol(***, **, *) adjr2 bdec(3) rdec(2) 
reg lnfeefeetotal lnfeexpapp yearconfirmed leadccatty fa specatty nonrandom, cluster(companyname)
outreg2 using Table8_4.rtf, append /// 
	ctitle("FeeFeeTotal","(log)") label alpha(0.001, 0.01, 0.05) symbol(***, **, *) adjr2 bdec(3) rdec(2) 
	
/// This is a passing detail after Table 8.4 in the discussion of Global Crossing's fee committee
/// It demonstrates the scale effect in fee application costs of -.46
reg lnfeefeetotalpct lnfeexpapp yearconfirmed leadccatty fa specatty nonrandom, cluster(companyname)



log close
